import sys, getopt
import numpy as np
from genax import gen_angels_to_pick, angles_alap, angles_ratet
from gpu import start_kernel
from utils import convert, printresults, search, exact_one, exact_one_gpu, filter_gpu, writetofile, writetofile2

def main(argv):
   outputfile = None
   n = 3
   v = 3
   w = 3
   PLOT = False

   try:
      opts, args = getopt.getopt(argv,"hpn:v:w:d:o:")
   except getopt.GetoptError as err:
      print(err)
      print ('tetrarun.py -n <range division:int> -v <> -w <> -o <outputfile>')
      sys.exit(2)
   for opt, arg in opts:
      if opt == '-h':
         print ('tetrarun.py -n <range divison> -v <> -w <> -o <outputfile>')
         sys.exit()
      elif opt in ("-n", "--rangediv"):
         n = int(arg)
         if n % 2 == 0:
            raise "n%2==0"
      elif opt in ("-v", "--rangediv"):
         v = int(arg)
      elif opt in ("-w", "--rangediv"):
         w = int(arg)
      elif opt in ("-o", "--ofile"):
         outputfile = arg
      elif opt in ("-p", "--plot"):
         PLOT = True

   space = gen_angels_to_pick(n, PLOT)

   Cx, Cy = angles_alap(space, PLOT)

   Dx, Dy, Dz = angles_ratet(space)

   res = start_kernel(Cx, Cy, Dx, Dy, Dz, v, w)

   Cx_cpu = np.zeros(Cx.size, dtype=np.float64)
   Cx.get(out=Cx_cpu)
   Cy_cpu = np.zeros(Cy.size, dtype=np.float64)
   Cy.get(out=Cy_cpu)
   Dx_cpu = np.zeros(Dx.size, dtype=np.float64)
   Dx.get(out=Dx_cpu)
   Dy_cpu = np.zeros(Dy.size, dtype=np.float64)
   Dy.get(out=Dy_cpu)
   Dz_cpu = np.zeros(Dz.size, dtype=np.float64)
   Dz.get(out=Dz_cpu)
   mtx_cpu = np.zeros(res.size, dtype=np.int8).reshape(res.shape)
   res.get(out=mtx_cpu)
   
   if outputfile:
      writetofile(outputfile+'.full', Cx_cpu, Cy_cpu, Dx_cpu, Dy_cpu, Dz_cpu, mtx_cpu)
      writetofile2(outputfile, Cx_cpu, Cy_cpu, Dx_cpu, Dy_cpu, Dz_cpu, mtx_cpu)

   #printresults(res)
   #print("Exact one 3-3")
   #exact_one_gpu(res, 3-1, 3-1)
   #print("Filter 2-1")
   #filter21 = filter_gpu(res, 2-1, 1-1)

if __name__ == "__main__":
   main(sys.argv[1:])