import sys, getopt
import numpy as np
import cupy as cp
import os
from genax import gen_angels_to_pick, angles_alap, angles_ratet
from gpu import start_kernel, start_kernel_save_points
from utils import convert, printresults, search, exact_one, exact_one_gpu, filter_gpu, writetofile, writetofile2
from mpi import size, rank
from pyntcloud import PyntCloud

def main(argv):
   outputfile = None
   n = 3
   v = 3
   w = 3
   PLOT = False
   mpi = False
   binary = False

   try:
      opts, args = getopt.getopt(argv,"hpn:v:w:d:o:mb")
   except getopt.GetoptError as err:
      print(err)
      print ('tetrarun.py -n <range division:int> -v <> -w <> -o <outputfile>')
      sys.exit(2)
   for opt, arg in opts:
      if opt == '-h':
         print ('tetrarun.py -n <range divison> -v <> -w <> -o <outputfile>')
         sys.exit()
      elif opt in ("-n", "--rangediv"):
         n = int(arg)
         if n % 2 == 0:
            raise "n%2==0"
      elif opt in ("-v", "--rangediv"):
         v = int(arg)
      elif opt in ("-w", "--rangediv"):
         w = int(arg)
      elif opt in ("-o", "--ofile"):
         outputfile = arg
      elif opt in ("-p", "--plot"):
         PLOT = True
      elif opt in ("-m", "--mpi"):
         mpi = True
      elif opt in ("-b", "--bin"):
         binary = True

   if outputfile and binary and rank == 0:
      os.mkdir(outputfile)

   space = gen_angels_to_pick(n)

   Cx, Cy = angles_alap(space)

   Dx, Dy, Dz = angles_ratet(space, mpi)

   if outputfile and not binary:

      Cx_cpu = np.zeros(Cx.size, dtype=np.float64)
      Cx.get(out=Cx_cpu)
      Cy_cpu = np.zeros(Cy.size, dtype=np.float64)
      Cy.get(out=Cy_cpu)
      Dx_cpu = np.zeros(Dx.size, dtype=np.float64)
      Dx.get(out=Dx_cpu)
      Dy_cpu = np.zeros(Dy.size, dtype=np.float64)
      Dy.get(out=Dy_cpu)
      Dz_cpu = np.zeros(Dz.size, dtype=np.float64)
      Dz.get(out=Dz_cpu)

      res = start_kernel(Cx, Cy, Dx, Dy, Dz, v, w)

      mtx_cpu = np.zeros(res.size, dtype=np.int8).reshape(res.shape)
      res.get(out=mtx_cpu)
   
      writetofile(outputfile+'.full', Cx_cpu, Cy_cpu, Dx_cpu, Dy_cpu, Dz_cpu, mtx_cpu, mpi)
      #writetofile2(outputfile, Cx_cpu, Cy_cpu, Dx_cpu, Dy_cpu, Dz_cpu, mtx_cpu, mpi)

   if outputfile and binary:
      offset = ''
      if mpi:
         offset = f"R{rank}-{size}"
      res = start_kernel(Cx, Cy, Dx, Dy, Dz, v, w)
      # os.mkdir(outputfile)
      cp.save(f"{outputfile}/{offset}_Cx.npy", Cx)
      cp.save(f"{outputfile}/{offset}_Cy.npy", Cy)
      cp.save(f"{outputfile}/{offset}_Dx.npy", Dx)
      cp.save(f"{outputfile}/{offset}_Dy.npy", Dy)
      cp.save(f"{outputfile}/{offset}_Dz.npy", Dz)
      cp.save(f"{outputfile}/{offset}_mtx.npy", res)

   #printresults(res)
   #print("Exact one 3-3")
   #exact_one_gpu(res, 3-1, 3-1)
   #print("Filter 2-1")
   #filter21 = filter_gpu(res, 2-1, 1-1)

lines = [
    {
        "color": "red",
        "vertices": [[0, 0, 0], [10, 0, 0]]
    },
    {
        "color": "green",
        "vertices": [[0, 0, 0], [0, 10, 0]]
    },
    {
        "color": "blue",
        "vertices": [[0, 0, 0], [0, 0, 10]]
    }
]

def save_points(Cx = 1, Cy = 0, Dx = 0, Dy = 0, Dz = 1, v = 4, w = 4):
   points, types = start_kernel_save_points(Cx, Cy, Dx, Dy, Dz, v, w)
   points = pd.DataFrame(
      points.astype(np.double), 
      columns=['x', 'y', 'z'])
   cloud = PyntCloud(points)
   cloud.plot(polylines=lines)

if __name__ == "__main__":
   main(sys.argv[1:])
