__device__ inline bool check_exact_one(char* mtx) {
    int sum = 0;
    for (int i = 0; i < 4; i++) {
        for (int j = 0; j < 4; j++) {
            sum += mtx[i*4 + j];
        }
    }
    return sum == 1;
}

__device__ inline bool check_exact_one(char* mtx, int S, int U) {
    return check_exact_one(mtx) && mtx[S*4 + U] == 1;
}

__global__ void exact_one(char* egysulyi_mtx, int len, bool* ok_arr, int S, int U) {
    int pos = blockDim.x * blockIdx.x + threadIdx.x;
    if (pos >= len)
        return;
    ok_arr[pos] = check_exact_one(egysulyi_mtx + pos*16, S, U);
}

__device__ inline bool check_filter(char* mtx, int S, int U) {
    if (mtx[4*S + U] == 1)
        return true;
    return false;
}

__global__ void filter(char* egysulyi_mtx, int len, bool* ok_arr, int S, int U) {
    int pos = blockDim.x * blockIdx.x + threadIdx.x;
    if (pos >= len)
        return;
    ok_arr[pos] = check_filter(egysulyi_mtx + pos*16, S, U);
}