import sys, getopt

from genax import gen_angels_to_pick, angles_alap, angles_ratet
from gpu import start_kernel

def main(argv):
   outputfile = 'out.txt'
   n = 3
   v = 3
   w = 3
   PLOT = False

   try:
      opts, args = getopt.getopt(argv,"hpn:v:w:d:")
   except getopt.GetoptError as err:
      print(err)
      print ('tetrarun.py -n <range division:int> -v <> -w <> -o <outputfile>')
      sys.exit(2)
   for opt, arg in opts:
      if opt == '-h':
         print ('tetrarun.py -n <range divison> -v <> -w <> -o <outputfile>')
         sys.exit()
      elif opt in ("-n", "--rangediv"):
         n = int(arg)
         if n % 2 == 0:
            raise "n%2==0"
      elif opt in ("-v", "--rangediv"):
         v = int(arg)
      elif opt in ("-w", "--rangediv"):
         w = int(arg)
      elif opt in ("-o", "--ofile"):
         outputfile = arg
      elif opt in ("-p", "--plot"):
         PLOT = True

   space = gen_angels_to_pick(n, PLOT)
   Cx, Cy = angles_alap(space, PLOT)
   
   Dx, Dy, Dz = angles_ratet(space)

   res = start_kernel(Cx, Cy, Dx, Dy, Dz, v, w)

   #print(res)

if __name__ == "__main__":
   main(sys.argv[1:])