from django.conf import settings
from django.apps import AppConfig
from django.db import OperationalError


class DefaultLeaseConfig(AppConfig):
    name = 'vm'

    def ready(self):
        from vm.models import Lease

        try:
            Lease.objects.get(name=settings.DEFAULT_LEASE_NAME)
        except Lease.DoesNotExist:
            Lease(
                name=settings.DEFAULT_LEASE_NAME,
                suspend_interval_seconds=settings.DEFAULT_LEASE_SUSPEND_SECONDS,
                delete_interval_seconds=settings.DEFAULT_LEASE_DELETE_SECONDS,
            ).save()
        except OperationalError:
            pass  # this could be raised on migration
