from django.template import Library
from django.urls import reverse
from django.utils.translation import ugettext_lazy as _

register = Library()

@register.filter
def get_status_icon(instance):
    return {
        'BUILDING': 'fa-rocket',
        'ACTIVE': 'fa-play',
        'SHUTOFF': 'fa-stop',
        'SUSPENDED': 'fa-pause',
        'ERROR': 'fa-warning',
        'SOFT_DELETED': 'fa-trash-o',
        'HARD_DELETED': 'fa-trash-o',
    }.get(instance.status, 'fa-question')

@register.filter
def get_status_display(instance):
    DISPLAYS = {
        'PAUSED': _('paused'),
        'SUSPENDED': _('suspended'),
        'ACTIVE': _('active'),
        'SHUTOFF': _('shutoff'),
        'RESCUED': _('rescued'),
        'STOPPED': _('stopped'),
        'SOFT_DELETED': _('soft deleted'),
        'ERROR': _('error'),
        'BUILDING': _('building'),
    }

    return DISPLAYS[instance.status] if instance.status in DISPLAYS else instance.status

@register.filter
def get_absolute_url(instance):
    return reverse('dashboard.views.detail', args=[instance.id])