class PolicyMiddleware(object):
    def process_request(self, request):
        user = request.user

        if hasattr(user, 'project_id'):
            setattr(user, 'permissions', {})

            from django.utils.module_loading import import_string
            check = import_string("openstack_auth.policy.check")

            has_perm_request_decide = check((("circle", "request:decide"),), request,
                                            {'project_id': user.project_id})

            user.permissions["request_decide"] = has_perm_request_decide