#ifndef COMPUTEWIDGET_H
#define COMPUTEWIDGET_H

#include <QWidget>
#include <QPixmap>

namespace Ui {
class ComputeWidget;
}

class ComputeWidget : public QWidget
{
    Q_OBJECT

public:
    std::string id;
    std::string name;
    explicit ComputeWidget(QWidget *parent = 0);
    void setID(std::string id);
    void setName(std::string name);
    ~ComputeWidget();

signals:
    void startshutdown(std::string id);
    void wakeupsleep(std::string id);
    void renew(std::string id);

public slots:
    void stateChangedHandler(std::string newState, std::string id);

private slots:
    void on_bRenew_clicked();

    void on_bWakeUpSleep_clicked();

    void on_bStartShutdown_clicked();

private:
    Ui::ComputeWidget *ui;
};

#endif // COMPUTEWIDGET_H
