#include "vmchooserdialog.h"
#include "ui_vmchooserdialog.h"

VMChooserDialog::VMChooserDialog(QWidget *parent):QDialog(parent), ui(new Ui::VMChooserDialog)
{
    ui->setupUi(this);
}

VMChooserDialog::~VMChooserDialog(){
    delete ui;
}

void VMChooserDialog::on_buttonBox_accepted()
{
    emit send_chosen_template(templates.at(ui->lwTemplates->currentIndex().row()));
    this->done(1);
}

void VMChooserDialog::on_buttonBox_rejected()
{
    this->done(-1);
}

void VMChooserDialog::set_templates(std::vector<Template> _templates){
    templates = _templates;
    for(auto t : templates){
        ui->lwTemplates->addItem(QString::fromUtf8(t.c_str()));
    }
}


