#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QLabel>
#include <QPushButton>
#include <QListWidget>
#include <computewidget.h>
#include "libocci/occilib.h"
#include "controller.h"
#include "vmchooserdialog.h"
#include <qtermwidget5/qtermwidget.h>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void addVM(std::string id, std::string name);
    void loadAllData();
    void loadVMData(std::string id);

signals:
    void stateChanged(std::string state, std::string id);

private slots:
    void on_bLogin_clicked();
    void renewClicked(std::string);
    void startshutdownClicked(std::string);
    void wakeupsleepClicked(std::string);

    void receive_chosen_template(Template);

    void on_listWidget_clicked(const QModelIndex &index);

    void on_bRefresh_clicked();

    void on_bNewVM_clicked();

    void on_bShowPassword_clicked();

    void on_bConnect_clicked();

private:
    Ui::MainWindow *ui;
    Controller myController;
    std::vector<std::string> VM_names;
    ComputeData currentSelectedVM;
};

#endif // MAINWINDOW_H
