#ifndef CONTROLLER_H
#define CONTROLLER_H

#include <QObject>
#include <vector>
#include <memory>
#include "occilib.h"
#include "computedata.h"

class Controller
{
public:
    OcciClient::OcciSession* session;
    std::vector<std::shared_ptr<OcciClient::Compute> > allCompute;
    std::vector<Template> allTemplate;

    bool connect(std::string url);

    bool login(std::string username, std::string password);

    void refresh();

    void renewByID(std::string id);

    void startByID(std::string id);

    void shutdownByID(std::string id);

    void wakeupByID(std::string id);

    void sleepByID(std::string id);

    void newCompute(Template);

    ComputeData getDataByID(std::string id);

    std::string getState(std::string id);

    std::vector<std::string> getVMs();

    std::vector<std::string> getTemplates();
};

#endif // CONTROLLER_H
