#include "controller.h"

///Implementation for class Controller

/*!
 * \brief Connects to the cloud server specified by the url
 * \param url
 * \return
 */
bool Controller::connect(std::string url){
    session = new OcciClient::OcciSession(url.c_str(), true, true);
    return true; //TODO validation
}

/*!
 * \brief Logs in to a connected server, loads all data into the Controller
 * \param username
 * \param password
 * \return
 */
bool Controller::login(std::string username, std::string password){
    session->circleOcciLogin(username, password);
    if(username == "admin" && password == "admin"){ //TODO TODO lib should handle this
        refresh(); //initialize data
        return true;
    }
    return false;
}

/*!
 * \brief Refreshes all data (Computes, Templates), communicates with the server
 */
void Controller::refresh(){
    allCompute.clear();
    for(auto c : OcciClient::Compute::getComputeInstances(session))
        allCompute.push_back(c);
    allTemplate.clear();
    for (auto t : OcciClient::getTemplates(session))
        allTemplate.push_back(t);
}


///Data Access
/// ----------------------------------------------------------------------------------

/*!
 * \brief Returns with an std::vector of the VM ids
 * \return
 */
std::vector<std::string> Controller::getVMs(){
    std::vector<std::string> VMs;
    for(auto c : allCompute){
        VMs.push_back(c->getHostname());
    }
    return VMs;
}

/*!
 * \brief Returns with an std::vector of the Template ids
 * \return
 */
std::vector<std::string> Controller::getTemplates(){
    std::vector<std::string> templates;
    for(auto t : allTemplate){
        templates.push_back(t);
    }
    return templates;
}

/*!
 * \brief Returns the state of the VM specified by the id
 * \param id
 * \return
 */
std::string Controller::getState(std::string id){
    return allCompute.at(std::stoi(id))->getState();
}

/*!
 * \brief Returns with a ComputeData objects which contains all information about the specified VM
 * \param id
 * \return
 */
ComputeData Controller::getDataByID(std::string id){
    ComputeData data;
    data.name = allCompute.at(std::stoi(id))->getHostname();
    data.memory = allCompute.at(std::stoi(id))->getMemory();
    data.cpu = allCompute.at(std::stoi(id))->getCpuShare();
    data.cores = allCompute.at(std::stoi(id))->getCores();
    data.hostname = allCompute.at(std::stoi(id))->getCredentialHost();
    data.port = allCompute.at(std::stoi(id))->getCredentialPort();
    data.username = allCompute.at(std::stoi(id))->getCredentialUsername();
    data.password = allCompute.at(std::stoi(id))->getCredentialPassword();
    data.connString = allCompute.at(std::stoi(id))->getCredentialCommand();
    return data;
}

///Actions
/// ----------------------------------------------------------------------------------

/*!
 * \brief Renew action
 * \param id
 */
void Controller::renewByID(std::string id){
    allCompute.at(std::stoi(id))->renew();
    refresh();
}

/*!
 * \brief Start action
 * \param id
 */
void Controller::startByID(std::string id){
    allCompute.at(std::stoi(id))->start();
    refresh();
}

/*!
 * \brief Shutdown action
 * \param id
 */
void Controller::shutdownByID(std::string id){
    allCompute.at(std::stoi(id))->shutoff(); //TODO modositani shutdownra tesztelesnel csak a shutoff mukodik
    refresh();
}

/*!
 * \brief Wakeup action
 * \param id
 */
void Controller::wakeupByID(std::string id){
    allCompute.at(std::stoi(id))->wakeup();
    refresh();
}

/*!
 * \brief Sleep action
 * \param id
 */
void Controller::sleepByID(std::string id){
    allCompute.at(std::stoi(id))->sleep();
    refresh();
}

/*!
 * \brief Creates a new Compute by the Template
 * \param id
 */
void Controller::newCompute(Template t){
    OcciClient::Compute::createComputeInstance(session, t);
    refresh();
}
