#include "computewidget.h"
#include "ui_computewidget.h"

ComputeWidget::ComputeWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ComputeWidget)
{
    ui->setupUi(this);
    ui->lComputeIcon->setPixmap(QPixmap(":/new/icons/compute.png").scaled(80, 55, Qt::KeepAspectRatio));
    ui->bRenew->setStyleSheet("background-color:blue");
}

void ComputeWidget::setID(std::string _id){
    id = _id;
}

void ComputeWidget::setName(std::string _name){
    name = _name;
    ui->lHostName->setText(_name.c_str());
}

ComputeWidget::~ComputeWidget()
{
    delete ui;
}

void ComputeWidget::on_bRenew_clicked()
{
    emit renew(id);
}

void ComputeWidget::on_bStartShutdown_clicked()
{
    emit startshutdown(id);
}

void ComputeWidget::on_bWakeUpSleep_clicked()
{
    emit wakeupsleep(id);
}

/*!
 * \brief Implements a state machine for showing the appropriate buttons for each state
 * \param newState
 * \param _id
 */
void ComputeWidget::stateChangedHandler(std::string newState, std::string _id){
    if(id == _id){ //check if we changed or not
        if(newState == "inactive"){
            ui->bStartShutdown->setVisible(true);
            ui->bStartShutdown->setEnabled(true);
            ui->bStartShutdown->setText("Start");
            ui->bStartShutdown->setStyleSheet("background-color:green");
            ui->bWakeUpSleep->setVisible(false);
            ui->bWakeUpSleep->setEnabled(false);
            ui->lStatusIcon->setPixmap(QPixmap(":/new/icons/stopped.png").scaled(80, 55, Qt::KeepAspectRatio));
        }
        else if(newState == "suspended"){
            ui->bStartShutdown->setVisible(false);
            ui->bStartShutdown->setEnabled(false);
            ui->bWakeUpSleep->setVisible(true);
            ui->bWakeUpSleep->setEnabled(true);
            ui->bWakeUpSleep->setText("Wake up");
            ui->bWakeUpSleep->setStyleSheet("background-color:green");
            ui->lStatusIcon->setPixmap(QPixmap(":/new/icons/suspended.png").scaled(80, 55, Qt::KeepAspectRatio));
        }
        else if(newState == "active"){
            ui->bStartShutdown->setVisible(true);
            ui->bStartShutdown->setEnabled(true);
            ui->bStartShutdown->setText("Shut down");
            ui->bStartShutdown->setStyleSheet("background-color:red");
            ui->bWakeUpSleep->setVisible(true);
            ui->bWakeUpSleep->setEnabled(true);
            ui->bWakeUpSleep->setText("Sleep");
            ui->bWakeUpSleep->setStyleSheet("background-color:yellow");
            ui->lStatusIcon->setPixmap(QPixmap(":/new/icons/running.png").scaled(80, 55, Qt::KeepAspectRatio));
        }
        else
            throw std::runtime_error("undefined VM state!");
    }
}


