import React from 'react'
import ReactDOM from 'react-dom'
import thunk from 'redux-thunk'
import logger from 'redux-logger'
import { createStore, applyMiddleware } from 'redux'
import 'semantic-ui-css/semantic.min.css'

import Root from './Root'
import reducer from './reducers'

const store = createStore(reducer, applyMiddleware(thunk), applyMiddleware(logger))

ReactDOM.render(<Root store={store} />, document.getElementById('root'))
