import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _VlanList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['vid', 'name', 'network4', 'network6', 'domain_name'],
      url: '/api/v1/network/vlans/?page_size=25',
      name: 'vlans',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props
    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='Vlans'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({ data: { vlans, isDataFetching }, options: { vlansOptions, isOptionsFetching } }) => ({
  data: vlans,
  options: vlansOptions,
  isDataFetching,
  isOptionsFetching,
})

const VlanList = withRouter(connect(mapStateToProps)(_VlanList))
export { VlanList }
