import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _VlanGroupList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['name', /* TODO: 'vlans', */ 'description', 'owner_name'],
      url: '/api/v1/network/vlangroups/?page_size=25',
      name: 'vlangroups',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props
    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='VlanGroups'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({ data: { vlangroups, isDataFetching }, options: { vlangroupsOptions, isOptionsFetching } }) => ({
  data: vlangroups,
  options: vlangroupsOptions,
  isDataFetching,
  isOptionsFetching,
})

const VlanGroupList = withRouter(connect(mapStateToProps)(_VlanGroupList))
export { VlanGroupList }
