import React, { Component } from 'react'
import { connect } from 'react-redux'
import { postData, fetchData } from '../actions'
import VlanGroupForm from '../components/VlanGroupForm'
import Wrapper from '../components/Wrapper'


class VlanGroupFormContainer extends Component {
  componentDidMount() {
    const { dispatch } = this.props
    dispatch(fetchData('owners', '/api/v1/dashboard/user/'))
    dispatch(fetchData('vlans', '/api/v1/network/vlans/'))
  }

  genOwnerOptions() {
    const { owners } = this.props.data
    if (owners === undefined) { return [] }
    return owners.map(owner => ({ key: owner.url, text: `${owner.full_name} (${owner.email})`, value: owner.url }))
  }

  genVlansOptions() {
    const { vlans } = this.props.data
    if (vlans === undefined) { return [] }
    return vlans.map(vlan => ({ key: vlan.url, text: vlan.name, value: vlan.url }))
  }

  render() {
    const { handleSubmit } = this.props
    return (
      <Wrapper title='VlanGroup'>
        <VlanGroupForm
          onSubmit={handleSubmit}
          ownerOptions={() => this.genOwnerOptions()}
          vlansOptions={() => this.genVlansOptions()}
        />
      </Wrapper>
    )
  }
}

const mapStateToProps = ({ data }) => ({ data })

const mapDispatchToProps = dispatch => ({
  handleSubmit: data => dispatch(postData('/api/v1/network/vlangroups/', data)),
  dispatch,
})

// TODO: Add id parameter for handleSubmit
export default connect(mapStateToProps, mapDispatchToProps)(VlanGroupFormContainer)
