import React, { Component } from 'react'
import { connect } from 'react-redux'
import { postData, fetchData } from '../actions'
import VlanForm from '../components/VlanForm'
import Wrapper from '../components/Wrapper'


class VlanFormContainer extends Component {
  componentDidMount() {
    const { dispatch } = this.props
    dispatch(fetchData('natsTo', '/api/v1/network/vlans/'))
    dispatch(fetchData('domains', '/api/v1/network/vlans/'))
    dispatch(fetchData('owners', '/api/v1/dashboard/user/'))
  }

  genNatToOptions() {
    const { natsTo } = this.props.data
    if (natsTo === undefined) { return [] }
    return natsTo.map(natTo => ({ key: natTo.url, text: natTo.name, value: natTo.url }))
  }

  genDomainOptions() {
    const { domains } = this.props.data
    if (domains === undefined) { return [] }
    return domains.map(domain => ({ key: domain.url, text: domain.name, value: domain.url }))
  }

  genOwnerOptions() {
    const { owners } = this.props.data
    if (owners === undefined) { return [] }
    return owners.map(owner => ({ key: owner.url, text: `${owner.full_name} (${owner.email})`, value: owner.url }))
  }

  render() {
    const { handleSubmit } = this.props
    return (
      <Wrapper title='Vlan'>
        <VlanForm
          onSubmit={handleSubmit}
          natToOptions={() => this.genNatToOptions()}
          domainOptions={() => this.genDomainOptions()}
          ownerOptions={() => this.genOwnerOptions()}
        />
      </Wrapper>
    )
  }
}

const mapStateToProps = ({ data }) => ({ data })

const mapDispatchToProps = dispatch => ({
  handleSubmit: data => dispatch(postData('/api/v1/network/vlans/', data)),
  dispatch,
})

export default connect(mapStateToProps, mapDispatchToProps)(VlanFormContainer)
