import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _SwitchPortList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['untagged_vlan_info', 'tagged_vlans_name'],
      url: '/api/v1/network/switchports/?page_size=25',
      name: 'switchports',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props
    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='SwitchPorts'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({ data: { switchports, isDataFetching }, options: { switchportsOptions, isOptionsFetching } }) => ({
  data: switchports,
  options: switchportsOptions,
  isDataFetching,
  isOptionsFetching,
})

const SwitchPortList = withRouter(connect(mapStateToProps)(_SwitchPortList))
export { SwitchPortList }
