import React, { Component } from 'react'
import { connect } from 'react-redux'
import { postData, fetchData } from '../actions'
import SwitchPortForm from '../components/SwitchPortForm'
import Wrapper from '../components/Wrapper'


class SwitchPortFormContainer extends Component {
  componentDidMount() {
    const { dispatch } = this.props
    dispatch(fetchData('taggedVlans', '/api/v1/network/vlangroups/'))
    dispatch(fetchData('untaggedVlan', '/api/v1/network/vlans/'))
  }

  genTaggedVlansOptions() {
    const { taggedVlans } = this.props.data
    if (taggedVlans === undefined) { return [] }
    return taggedVlans.map(vlanGroup => ({ key: vlanGroup.url, text: vlanGroup.name, value: vlanGroup.url }))
  }

  genUnTaggedVlanOptions() {
    const { untaggedVlan } = this.props.data
    if (untaggedVlan === undefined) { return [] }
    return untaggedVlan.map(vlan => ({ key: vlan.url, text: vlan.name, value: vlan.url }))
  }

  render() {
    const { handleSubmit } = this.props
    return (
      <Wrapper title='SwitchPort'>
        <SwitchPortForm
          onSubmit={handleSubmit}
          taggedVlansOptions={() => this.genTaggedVlansOptions()}
          unTaggedVlanOptions={() => this.genUnTaggedVlanOptions()}
        />
      </Wrapper>
    )
  }
}

const mapStateToProps = ({ data }) => ({ data })

const mapDispatchToProps = dispatch => ({
  handleSubmit: data => dispatch(postData('/api/v1/network/switchports/', data)),
  dispatch,
})

// TODO: Add id parameter for handleSubmit
export default connect(mapStateToProps, mapDispatchToProps)(SwitchPortFormContainer)
