import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _RuleList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['direction', 'description', 'proto', 'dport'],
      url: '/api/v1/network/rules/?page_size=25',
      name: 'rules',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props
    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='Rules'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({ data: { rules, isDataFetching }, options: { rulesOptions, isOptionsFetching } }) => ({
  data: rules,
  options: rulesOptions,
  isDataFetching,
  isOptionsFetching,
})

const RuleList = withRouter(connect(mapStateToProps)(_RuleList))
export { RuleList }
