import React from 'react'
import { connect } from 'react-redux'
import { postData } from '../actions'
import RuleForm from '../components/RuleForm'
import Wrapper from '../components/Wrapper'


const RuleFormContainer = ({ handleSubmit }) => (
  <Wrapper title='Rule'>
    <RuleForm onSubmit={handleSubmit} />
  </Wrapper>
)

// TODO: Add id parameter for handleSubmit
export default connect(null, {
  handleSubmit: data => postData('/api/v1/network/rules/', data),
})(RuleFormContainer)
