import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _RecordList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['type', 'fqdn', 'host_name', 'address', 'ttl', 'owner_name'],
      url: '/api/v1/network/records/?page_size=25',
      name: 'records',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props
    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='Records'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({ data: { records, isDataFetching }, options: { recordsOptions, isOptionsFetching } }) => ({
  data: records,
  options: recordsOptions,
  isDataFetching,
  isOptionsFetching,
})

const RecordList = withRouter(connect(mapStateToProps)(_RecordList))
export { RecordList }
