import React, { Component } from 'react'
import { connect } from 'react-redux'
import { postData, fetchData } from '../actions'
import RecordForm from '../components/RecordForm'
import Wrapper from '../components/Wrapper'


class RecordFormContainer extends Component {
  componentDidMount() {
    const { dispatch } = this.props
    dispatch(fetchData('hosts', '/api/v1/network/hosts/'))
    dispatch(fetchData('domains', '/api/v1/network/domains/'))
    dispatch(fetchData('owners', '/api/v1/dashboard/user/'))
  }

  genHostOptions() {
    const { hosts } = this.props.data
    if (hosts === undefined) { return [] }
    return hosts.map(host => ({ key: host.url, text: host.hostname, value: host.url }))
  }

  genDomainOptions() {
    const { domains } = this.props.data
    if (domains === undefined) { return [] }
    return domains.map(domain => ({ key: domain.url, text: domain.name, value: domain.url }))
  }

  genOwnerOptions() {
    const { owners } = this.props.data
    if (owners === undefined) { return [] }
    return owners.map(owner => ({ key: owner.url, text: `${owner.full_name} (${owner.email})`, value: owner.url }))
  }


  render() {
    const { handleSubmit } = this.props
    return (
      <Wrapper title='Record'>
        <RecordForm
          onSubmit={handleSubmit}
          hostOptions={() => this.genHostOptions()}
          domainOptions={() => this.genDomainOptions()}
          ownerOptions={() => this.genOwnerOptions()}
        />
      </Wrapper>
    )
  }
}

const mapStateToProps = ({ data }) => ({ data })

const mapDispatchToProps = dispatch => ({
  handleSubmit: data => dispatch(postData('/api/v1/network/records/', data)),
  dispatch,
})

// TODO: Add id parameter for handleSubmit
export default connect(mapStateToProps, mapDispatchToProps)(RecordFormContainer)
