import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _HostList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['hostname', 'vlan_name', 'mac', 'ipv4', 'ipv6', 'external_ipv4', 'created_at', 'owner_name'],
      url: '/api/v1/network/hosts/?page_size=25',
      name: 'hosts',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props

    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='Hosts'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({ data: { hosts, isDataFetching }, options: { hostsOptions, isOptionsFetching } }) => ({
  data: hosts,
  options: hostsOptions,
  isDataFetching,
  isOptionsFetching,
})

const HostList = withRouter(connect(mapStateToProps)(_HostList))
export { HostList }
