import React, { Component } from 'react'
import { connect } from 'react-redux'
import { postData, fetchData } from '../actions'
import HostForm from '../components/HostForm'
import Wrapper from '../components/Wrapper'


class HostFormContainer extends Component {
  componentDidMount() {
    const { dispatch } = this.props
    dispatch(fetchData('owners', '/api/v1/dashboard/user/'))
  }

  genSelectOptions() {
    const { owners } = this.props.data
    if (owners === undefined) { return [] }
    return owners.map(owner => ({ key: owner.url, text: `${owner.full_name} (${owner.email})`, value: owner.url }))
  }

  render() {
    const { handleSubmit } = this.props
    return (
      <Wrapper title='Host'>
        <HostForm onSubmit={handleSubmit} ownerOptions={() => this.genSelectOptions()} />
      </Wrapper>
    )
  }
}

const mapStateToProps = ({ data }) => ({ data })

const mapDispatchToProps = dispatch => ({
  handleSubmit: data => dispatch(postData('/api/v1/network/domains/', data)),
  dispatch,
})

// TODO: Add id parameter for handleSubmit
export default connect(mapStateToProps, mapDispatchToProps)(HostFormContainer)
