import React from 'react'
import { connect } from 'react-redux'
import { postData } from '../actions'
import FirewallForm from '../components/FirewallForm'
import Wrapper from '../components/Wrapper'


const FirewallFormContainer = ({ handleSubmit }) => (
  <Wrapper title='Firewall'>
    <FirewallForm onSubmit={handleSubmit} />
  </Wrapper>
)

// TODO: Add id parameter for handleSubmit
export default connect(null, {
  handleSubmit: data => postData('/api/v1/network/firewalls/', data),
})(FirewallFormContainer)
