import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _DomainList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['name', 'owner_name', 'ttl'],
      url: '/api/v1/network/domains/?page_size=25',
      name: 'domains',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props
    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='Domains'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({
  data: { domains, isDataFetching },
  options: { domainsOptions, isOptionsFetching }
}) => ({
  data: domains,
  options: domainsOptions,
  isDataFetching,
  isOptionsFetching,
})

const DomainList = withRouter(connect(mapStateToProps)(_DomainList))
export { DomainList }
