import React, { Component } from 'react'
import { withRouter } from 'react-router-dom'
import { connect } from 'react-redux'

import { fetchData, fetchOptions } from '../actions'
import DataTable from '../components/DataTable'
import Wrapper from '../components/Wrapper'


class _BlacklistList extends Component {
  constructor(props) {
    super(props)
    this.state = {
      fields: ['ipv4', 'host_name', 'reason', 'whitelisted', 'expires_at', 'created_at'],
      url: '/api/v1/network/blacklist/?page_size=25',
      name: 'blacklist',
    }
  }

  componentDidMount() {
    const { url } = this.state
    const { dispatch } = this.props
    dispatch(fetchData(this.state.name, url))
    dispatch(fetchOptions(this.state.name, url))
  }

  render() {
    const { fields, url, name } = this.state
    const { isDataFetching, isOptionsFetching, dispatch } = this.props
    if (isDataFetching === false && isOptionsFetching === false) {
      return (
        <Wrapper title='BlackList'>
          <DataTable
            {...this.props}
            fields={fields}
            url={url}
            onPagination={next => dispatch(fetchData(name, `${next}&page_size=25`))}
          />
        </Wrapper>
      )
    }

    return <div />
  }
}

const mapStateToProps = ({
  data: { blacklist, isDataFetching },
  options: { blacklistOptions, isOptionsFetching },
}) => ({
  data: blacklist,
  options: blacklistOptions,
  isDataFetching,
  isOptionsFetching,
})

const BlacklistList = withRouter(connect(mapStateToProps)(_BlacklistList))
export { BlacklistList }
