import React, { Component } from 'react'
import { connect } from 'react-redux'
import { postData, fetchData } from '../actions'
import BlacklistForm from '../components/BlacklistForm'
import Wrapper from '../components/Wrapper'


class BlacklistFormContainer extends Component {
  componentDidMount() {
    const { dispatch } = this.props
    dispatch(fetchData('hosts', '/api/v1/network/hosts/'))
  }

  genSelectOptions() {
    const { hosts } = this.props.data
    if (hosts === undefined) { return [] }
    return hosts.map(host => ({ key: host.url, text: host.hostname, value: host.url }))
  }

  render() {
    const { handleSubmit } = this.props
    console.log(this.props)
    return (
      <Wrapper title='Blacklist'>
        <BlacklistForm onSubmit={handleSubmit} hostOptions={() => this.genSelectOptions()} />
      </Wrapper>
    )
  }
}

const mapStateToProps = ({ data }) => ({ data })

const mapDispatchToProps = dispatch => ({
  handleSubmit: data => dispatch(postData('/api/v1/network/blacklist/', data)),
  dispatch,
})

// TODO: Add id parameter for handleSubmit
export default connect(mapStateToProps, mapDispatchToProps)(BlacklistFormContainer)
