import React from 'react'
import { reduxForm, Field } from 'redux-form'
import { Form } from 'semantic-ui-react'
import SemanticReduxFormField from '../components/SemanticReduxFormField'


const VlanGroupForm = ({
  pristine,
  submitting,
  handleSubmit,
  vlansOptions,
  ownerOptions,
}) => (
  <Form onSubmit={handleSubmit}>
    <Field component={Form.Input} type='text' placeholder='Name' name='name' />
    <Field
      options={vlansOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='vlans'
      type='text'
      search
      multiple
    />
    <Field component={Form.TextArea} label='Description' name='description' />
    <Field
      options={ownerOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='owner'
      type='text'
      search
    />
    <Form.Button disabled={pristine || submitting} type='submit'>Submit</Form.Button>
  </Form>
)

export default reduxForm({ form: 'domain' })(VlanGroupForm)
