import React from 'react'
import { reduxForm, formValueSelector, Field } from 'redux-form'
import { connect } from 'react-redux'
import { Form, Segment } from 'semantic-ui-react'
import SemanticReduxFormField from './SemanticReduxFormField'

const VlanForm = ({
  pristine,
  submitting,
  handleSubmit,
  networkType,
  natToOptions,
  domainOptions,
  ownerOptions,
}) => (
  <Form onSubmit={handleSubmit}>
    <Field component={Form.Input} type='text' placeholder='Name' name='name' />
    <Field component={Form.Input} type='number' placeholder='VID' name='vid' />
    <Field
      component={SemanticReduxFormField}
      as={Form.Select}
      type='text'
      options={[
        { key: 'public', value: 'public', text: 'Public' },
        { key: 'portforward', value: 'portforward', text: 'Portforward' },
      ]}
      name='network_type'
    />
    <Field component={Form.Input} type='text' placeholder='IPv4 address/prefix' name='network4' />
    <Field component={Form.Checkbox} name='managed' label='Managed' />
    { networkType === 'portforward' && (
      <Segment basic>
        <Field
          component={Form.Select}
          as={Form.Select}
          name='snat_to'
          options={natToOptions()}
          multiple
          search
        />
        <Field component={Form.Input} type='text' placeholder='Snat IP' name='snat_ip' />
        <Field component={Form.TextArea} name='dhcp_pool' />
      </Segment>
    )}

    <Field component={Form.Input} type='text' placeholder='IPv6 address/prefix' name='network6' />
    <Field component={Form.Input} type='text' placeholder='IPv6 template' name='ipv6_template' />
    <Field component={Form.Input} type='number' placeholder='IPv6 prefixlen/host' name='host_ipv6_prefixlen' />
    <Field component={Form.Input} type='text' placeholder='IPv6 template' name='ipv6_template' />

    <Field
      component={SemanticReduxFormField}
      as={Form.Select}
      type='text'
      name='domain'
      options={domainOptions()}
      search
    />
    <Field component={Form.Input} type='text' placeholder='Reverse Domain' name='reverse_domain' />

    <Field component={Form.TextArea} label='Description' name='description' />
    <Field component={Form.TextArea} label='Comment' name='comment' />

    <Field
      component={SemanticReduxFormField}
      as={Form.Select}
      type='text'
      name='owner'
      options={ownerOptions()}
      search
    />

    <Form.Button disabled={pristine || submitting} type='submit'>Submit</Form.Button>
  </Form>
)

const formName = 'vlan'
const selector = formValueSelector(formName)

const mapStateToProps = state => ({
  networkType: selector(state, 'network_type'),
})

export default connect(mapStateToProps)(reduxForm({ form: formName })(VlanForm))
