import React from 'react'
import { reduxForm, Field } from 'redux-form'
import { Form } from 'semantic-ui-react'
import SemanticReduxFormField from '../components/SemanticReduxFormField'


const SwitchPortForm = ({
  pristine,
  submitting,
  handleSubmit,
  taggedVlansOptions,
  unTaggedVlanOptions,
}) => (
  <Form onSubmit={handleSubmit}>
    <Field
      options={taggedVlansOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='tagged_vlans'
      label='Tagged Vlans'
      type='text'
      search
    />
    <Field
      options={unTaggedVlanOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='untagged_vlan'
      label='Untagged Vlan'
      type='text'
      search
    />
    <Field component={Form.TextArea} label='Description' name='description' />
    <Form.Button disabled={pristine || submitting} type='submit'>Submit</Form.Button>
  </Form>
)

export default reduxForm({ form: 'domain' })(SwitchPortForm)
