import React, { Component } from 'react'
import { Input } from 'semantic-ui-react'


export default class SemanticReduxFormField extends Component {
  handleChange(value) {
    const { input } = this.props
    return input.onChange(value)
  }

  render() {
    const { input, meta: { touched, error }, as: As = Input } = this.props
    return (
      <As
        {...input}
        value={input.value || []}
        {...this.props}
        onChange={(e, { value }) => this.handleChange(value)}
        error={touched && error}
      />
    )
  }
}
