import React from 'react'
import { reduxForm, Field } from 'redux-form'
import { Form } from 'semantic-ui-react'
import SemanticReduxFormField from '../components/SemanticReduxFormField'


const RecordForm = ({
  pristine,
  submitting,
  handleSubmit,
  hostOptions,
  domainOptions,
  ownerOptions,
}) => (
  <Form onSubmit={handleSubmit}>
    <Field
      options={[
        { key: 'A', value: 'A', text: 'A' },
        { key: 'CNAME', value: 'CNAME', text: 'CNAME' },
        { key: 'AAAA', value: 'AAAA', text: 'AAAA' },
        { key: 'MX', value: 'MX', text: 'MX' },
        { key: 'NS', value: 'NS', text: 'NS' },
        { key: 'PTR', value: 'PTR', text: 'PTR' },
        { key: 'TXT', value: 'TXT', text: 'TXT' },
      ]}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='type'
      type='text'
    />
    <Field
      options={hostOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='host'
      type='text'
      search
    />
    <Field component={Form.Input} type='text' placeholder='Name' name='name' />
    <Field
      options={domainOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='domain'
      type='text'
      search
    />
    <Field component={Form.Input} type='text' placeholder='Address' name='address' />
    <Field component={Form.Input} type='number' placeholder='Ttl' name='ttl' />
    <Field component={Form.TextArea} name='description' label='Description' />
    <Field
      options={ownerOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='owner'
      type='text'
      search
    />
    <Form.Button disabled={pristine || submitting} type='submit'>Submit</Form.Button>
  </Form>
)

export default reduxForm({ form: 'record' })(RecordForm)
