import React from 'react'
import { reduxForm, Field } from 'redux-form'
import { Form } from 'semantic-ui-react'


const FirewallForm = ({ pristine, submitting, handleSubmit }) => (
  <Form onSubmit={handleSubmit}>
    <Field component={Form.Input} type='text' placeholder='Name' name='name' />
    <Form.Button disabled={pristine || submitting} type='submit'>Submit</Form.Button>
  </Form>
)

export default reduxForm({ form: 'domain' })(FirewallForm)
