import React from 'react'
import { reduxForm, Field } from 'redux-form'
import { Form } from 'semantic-ui-react'
import SemanticReduxFormField from '../components/SemanticReduxFormField'


const BlacklistForm = ({
  pristine,
  submitting,
  hostOptions,
  handleSubmit,
}) => (
  <Form onSubmit={handleSubmit}>
    <Field component={Form.Input} type='text' placeholder='IPv4' name='ipv4' />
    <Field
      options={hostOptions()}
      component={SemanticReduxFormField}
      as={Form.Select}
      name='host'
      type='text'
      search
    />
    <Field component={Form.Input} type='datetime-local' name='expires_at' />
    <Field component={Form.Checkbox} label='Whitelisted' name='whitelisted' />
    <Field component={Form.TextArea} label='Reason' name='reason' />
    <Field component={Form.TextArea} label='Short Message' name='short_message' />
    <Form.Button disabled={pristine || submitting} type='submit'>Submit</Form.Button>
  </Form>
)

export default reduxForm({ form: 'blacklist' })(BlacklistForm)
