import axios from 'axios'

export const REQUEST_DATA = 'REQUEST_DATA'
export const RECEIVE_DATA = 'RECEIVE_DATA'
export const REQUEST_OPTIONS = 'REQUEST_OPTIONS'
export const RECEIVE_OPTIONS = 'RECEIVE_OPTIONS'

export const receiveData = (name, { data }) => ({
  type: RECEIVE_DATA,
  payload: {
    data,
    name,
    isFetching: false,
  },
})

export const requestData = name => ({
  type: REQUEST_DATA,
  payload: {
    data: [],
    name,
    isFetching: true,
  },
})

export const fetchData = (name, url) => (dispatch) => {
  dispatch(requestData(name))
  axios.get(url).then(response => dispatch(receiveData(name, response)))
}

const config = {
  xsrfCookieName: 'csrftoken',
  xsrfHeaderName: 'X-CSRFToken',
}

export const postData = (url, data) => () => axios.post(url, data, config)
export const putData = (url, data) => () => axios.put(url, data, config)
export const deleteData = url => () => axios.delete(url, config)

export const receiveOptions = (name, { data }) => ({
  type: RECEIVE_OPTIONS,
  payload: {
    options: data,
    name,
    isFetching: false,
  },
})

export const requestOptions = name => ({
  type: REQUEST_OPTIONS,
  payload: {
    options: {},
    name,
    isFetching: true,
  },
})

export const fetchOptions = (name, url) => (dispatch) => {
  dispatch(requestOptions(name))
  return axios.options(url).then(response => dispatch(receiveOptions(name, response)))
}

/* export const logMe = data => (
  async (dispatch) => {
    console.log(data)
    try {
      const response = await axios.post('url', data)
    } catch (err) {
      console.error(err)
    }
  }
) */
