import React from 'react'
import { Container, Dropdown, List, Menu, Segment } from 'semantic-ui-react'
import { NavLink, Link, Route } from 'react-router-dom'

import {
  HostList,
  VlanList,
  DomainList,
  RecordList,
  BlacklistList,
  RuleList,
  FirewallList,
  SwitchPortList,
  VlanGroupList,
  HostGroupList,
} from './containers'

import DomainFormContainer from './containers/DomainFormContainer'
import VlanFormContainer from './containers/VlanFormContainer'
import HostFormContainer from './containers/HostFormContainer'
import BlacklistFormContainer from './containers/BlacklistFormContainer'
import RuleFormContainer from './containers/RuleFormContainer'
import FirewallFormContainer from './containers/FirewallFormContainer'
import RecordFormContainer from './containers/RecordFormContainer'
import SwitchPortFormContainer from './containers/SwitchPortFormContainer'
import VlanGroupFormContainer from './containers/VlanGroupFormContainer'
import HostGroupFormContainer from './containers/HostGroupFormContainer'

const App = () => (
  <div>
    <Menu fixed='top' inverted>
      <Container>
        <Menu.Item as={Link} header to='/'>Circle Network</Menu.Item>
        <Menu.Item as={NavLink} to='/hosts'>Hosts</Menu.Item>
        <Menu.Item as={NavLink} to='/vlans'>Vlans</Menu.Item>
        <Menu.Item as={NavLink} to='/domains'>Domains</Menu.Item>
        <Menu.Item as={NavLink} to='/records'>Records</Menu.Item>
        <Menu.Item as={NavLink} to='/blacklist'>Blacklist</Menu.Item>
        <Menu.Item as={NavLink} to='/rules'>Rules</Menu.Item>
        <Menu.Item as={NavLink} to='/switchports'>Switch ports</Menu.Item>
        <Menu.Item as={NavLink} to='/firewalls'>Firewalls</Menu.Item>

        <Dropdown item simple text='Groups'>
          <Dropdown.Menu>
            <Dropdown.Item as={Link} to='/vlangroups'>Vlan groups</Dropdown.Item>
            <Dropdown.Item as={Link} to='/hostgroups'>Host groups</Dropdown.Item>
          </Dropdown.Menu>
        </Dropdown>
      </Container>
    </Menu>

    <Container text style={{ marginTop: '7em', marginBottom: '7em' }}>
      <Route path='/' exact />
      <Route path='/hosts' exact component={HostList} />
      <Route path='/hosts/:id' component={HostFormContainer} />
      <Route path='/vlans' exact component={VlanList} />
      <Route path='/vlans/:id' component={VlanFormContainer} />
      <Route path='/domains' exact component={DomainList} />
      <Route path='/domains/:id' component={DomainFormContainer} />
      <Route path='/records' exact component={RecordList} />
      <Route path='/records/:id' component={RecordFormContainer} />
      <Route path='/blacklist' exact component={BlacklistList} />
      <Route path='/blacklist/:id' component={BlacklistFormContainer} />
      <Route path='/rules' exact component={RuleList} />
      <Route path='/rules/:id' component={RuleFormContainer} />
      <Route path='/switchports' exact component={SwitchPortList} />
      <Route path='/switchports/:id' component={SwitchPortFormContainer} />
      <Route path='/firewalls' exact component={FirewallList} />
      <Route path='/firewalls/:id' component={FirewallFormContainer} />
      <Route path='/vlangroups' exact component={VlanGroupList} />
      <Route path='/vlangroups/:id' component={VlanGroupFormContainer} />
      <Route path='/hostgroups' exact component={HostGroupList} />
      <Route path='/hostgroups/:id' exact component={HostGroupFormContainer} />
    </Container>

    <Segment inverted vertical >
      <Container textAlign='center'>
        <List horizontal inverted divided link>
          <List.Item as='a' href='#'>Legal Notice</List.Item>
          <List.Item as='a' href='#'>Policy</List.Item>
          <List.Item as='a' href='#'>Help</List.Item>
          <List.Item as='a' href='#'>Support</List.Item>
        </List>
      </Container>
    </Segment>
  </div>
)

export default App
