package hu.bme.dszenasi.circleandroid.vmlist.ui;

import hu.bme.dszenasi.circleandroid.occicore.OCCIComputeResponse;
import hu.bme.dszenasi.circleandroid.occicore.OCCILoginResponse;
import hu.bme.dszenasi.circleandroid.vmlist.repository.IVmListRepository;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by danielszenasi on 28/04/16.
 */
public class VmListPresenterImpl implements VmListPresenter {
    VmListView view;
    IVmListRepository vmListRepository;

    public VmListPresenterImpl(IVmListRepository vmListRepository) {
        this.vmListRepository = vmListRepository;
    }

    public void destroyView() {
        view = null;
    }

    public void setView(VmListView view) {
        this.view = view;
    }

    public void getAllCompute() {
        Callback<OCCIComputeResponse> callback = new Callback<OCCIComputeResponse>() {
            @Override
            public void onResponse(Call<OCCIComputeResponse> call, Response<OCCIComputeResponse> response) {
                if (response.isSuccessful()) {
                    view.computeLoaded(response.body().getResources());
                } else {
                    int statusCode = response.code();
                    ResponseBody errorBody = response.errorBody();
                }
            }

            @Override
            public void onFailure(Call<OCCIComputeResponse> call, Throwable t) {
                int statusCode = 5;
            }
        };
        vmListRepository.getAllCompute(callback);

    }

}
