package hu.bme.dszenasi.circleandroid.vmlist.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;

import java.util.List;

import javax.inject.Inject;

import hu.bme.dszenasi.circleandroid.MyApplication;
import hu.bme.dszenasi.circleandroid.R;
import hu.bme.dszenasi.circleandroid.createvm.ui.CreateVmActivity;
import hu.bme.dszenasi.circleandroid.managevm.ui.ManageVmActivity;
import hu.bme.dszenasi.circleandroid.occicore.Resource;
import hu.bme.dszenasi.circleandroid.vmlist.adapter.VmAdapter;

/**
 * Created by mszenasi on 2016-04-26.
 */
public class VmListActivity extends AppCompatActivity implements VmListView {

    ListView listView;
    VmAdapter vmAdapter;
    @Inject
    VmListPresenter vmListPresenter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.vmlist_activity);
        injectDependencies();
        vmListPresenter.setView(this);
        listView = (ListView) findViewById(R.id.listView);
        vmListPresenter.getAllCompute();
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            public void onItemClick(AdapterView<?> adapterView, View view,
                                    int position, long id) {
                Intent intent = new Intent( VmListActivity.this , ManageVmActivity.class  );
                final Resource item = (Resource) adapterView.getItemAtPosition(position);
                intent.putExtra("resource", item);
                startActivity(intent);
            }
        });
        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                // Click action
                Intent intent = new Intent(VmListActivity.this, CreateVmActivity.class);
                startActivity(intent);
            }
        });

    }

    @Override
    public void onCreate(Bundle savedInstanceState, PersistableBundle persistentState) {
        super.onCreate(savedInstanceState, persistentState);
    }

    @Override
    protected void onDestroy() {
        vmListPresenter.destroyView();
        super.onDestroy();
    }

    @Override
    public void computeLoaded(List<Resource> resources) {
        vmAdapter = new VmAdapter(this, R.layout.vmlist_item, resources);
        listView.setAdapter(vmAdapter);

    }

    protected void injectDependencies() {
        ((MyApplication) getApplication()).getVmListComponent().inject(this);
    }
}
