package hu.bme.dszenasi.circleandroid.vmlist.module;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import hu.bme.dszenasi.circleandroid.core.util.ErrorUtil;
import hu.bme.dszenasi.circleandroid.core.util.SelfSigningClientBuilder;
import hu.bme.dszenasi.circleandroid.vmlist.repository.IVmListRepository;
import hu.bme.dszenasi.circleandroid.vmlist.repository.VmListRepository;
import hu.bme.dszenasi.circleandroid.vmlist.ui.VmListPresenter;
import hu.bme.dszenasi.circleandroid.vmlist.ui.VmListPresenterImpl;

import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by mszenasi on 2016-04-28.
 */
@Module
public class VmListModule {

    String mBaseUrl;

    // Constructor needs one parameter to instantiate.
    public VmListModule(String baseUrl) {
        this.mBaseUrl = baseUrl;
    }

    @Provides
    @Singleton
    public IVmListRepository providesVmListRepository(Retrofit retrofit) {
        return new VmListRepository(retrofit);
    }

    @Provides
    @Singleton
    public VmListPresenter providesVmListPresenter(IVmListRepository repository) {
        return new VmListPresenterImpl(repository);
    }

    @Provides
    @Singleton
    SharedPreferences providesSharedPreferences(Application application) {
        return PreferenceManager.getDefaultSharedPreferences(application);
    }

    @Provides
    @Singleton
    OkHttpClient provideOkHttpClient(Application application) {

        return SelfSigningClientBuilder.createClient(application);
    }

    //gson
    @Provides
    @Singleton
    Retrofit provideRetrofit(OkHttpClient okHttpClient) {
        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(mBaseUrl)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();
        return retrofit;
    }


}
