package hu.bme.dszenasi.circleandroid.vmlist.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.TextView;

import java.util.List;

import hu.bme.dszenasi.circleandroid.R;
import hu.bme.dszenasi.circleandroid.managevm.ui.ManageVmActivity;
import hu.bme.dszenasi.circleandroid.occicore.Resource;
import hu.bme.dszenasi.circleandroid.vmlist.ui.VmListActivity;

/**
 * Created by mszenasi on 2016-04-28.
 */
public class VmAdapter extends ArrayAdapter<Resource> {

    Context context;
    public VmAdapter(Context context, int resource, List<Resource> objects) {
        super(context, resource, objects);
        this.context=context;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if(convertView==null){
            LayoutInflater inflater = ((Activity) context).getLayoutInflater();
            convertView = inflater.inflate(R.layout.vmlist_item, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.hostname = (TextView) convertView.findViewById(R.id.hostname);
            viewHolder.status = (TextView) convertView.findViewById(R.id.status);
            convertView.setTag(viewHolder);
        }else{
            viewHolder = (ViewHolder) convertView.getTag();

        }
        final Resource resource = getItem(position);
        viewHolder.hostname.setText(resource.getAttributes().getComputeHostname());
        viewHolder.status.setText(resource.getAttributes().getComputeState());
        return convertView;
    }

    public class ViewHolder{
        TextView hostname;
        TextView status;
    }
}
