package hu.bme.dszenasi.circleandroid.occicore;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by danielszenasi on 08/05/16.
 */
public class Resource implements Parcelable {
    private Attributes attributes;
    private String kind;
    private int id;
    private List<String> actions;
    private List<String> mixins;

    public Attributes getAttributes() {
        return attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public String getKind() {
        return kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<String> getActions() {
        return actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public List<String> getMixins() {
        return mixins;
    }

    public void setMixins(List<String> mixins) {
        this.mixins = mixins;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeParcelable(attributes, i);
        parcel.writeString(kind);
        parcel.writeInt(id);
        parcel.writeStringList(actions);
        parcel.writeStringList(mixins);
    }

    // this is used to regenerate your object. All Parcelables must have a CREATOR that implements these two methods
    public static final Parcelable.Creator<Resource> CREATOR = new Parcelable.Creator<Resource>() {
        public Resource createFromParcel(Parcel in) {
            return new Resource(in);
        }

        public Resource[] newArray(int size) {
            return new Resource[size];
        }
    };

    // example constructor that takes a Parcel and gives you an object populated with it's values
    private Resource(Parcel in) {
        attributes = in.readParcelable(Attributes.class.getClassLoader());
        kind = in.readString();
        id = in.readInt();
        actions = new ArrayList<>();
        mixins = new ArrayList<>();
        in.readStringList(actions);
        in.readStringList(mixins);
    }
}
