package hu.bme.dszenasi.circleandroid.managevm.ui;

import hu.bme.dszenasi.circleandroid.core.util.ErrorUtil;
import hu.bme.dszenasi.circleandroid.managevm.repository.ManageVmRepository;
import hu.bme.dszenasi.circleandroid.occicore.Action;
import hu.bme.dszenasi.circleandroid.occicore.ActionAttributes;
import hu.bme.dszenasi.circleandroid.occicore.ActionWithAttributes;
import hu.bme.dszenasi.circleandroid.occicore.OCCIComputeResponse;
import hu.bme.dszenasi.circleandroid.occicore.OCCILoginResponse;
import hu.bme.dszenasi.circleandroid.occicore.Resource;
import hu.bme.dszenasi.circleandroid.vmlist.repository.IVmListRepository;
import hu.bme.dszenasi.circleandroid.vmlist.ui.VmListView;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created by mszenasi on 2016-04-28.
 */
public class ManageVmPresenterImpl implements ManageVmPresenter{
    ManageVmView view;
    ManageVmRepository manageVmRepository;
    ErrorUtil errorUtil;

    public ManageVmPresenterImpl(ManageVmRepository manageVmRepository, ErrorUtil errorUtil) {
        this.manageVmRepository = manageVmRepository;
        this.errorUtil = errorUtil;
    }

    public void destroyView() {
        view = null;
    }

    public void setView(ManageVmView view) {
        this.view = view;
    }

    public void startVm(int vmid, Action action){
        Callback<Resource> callback = new Callback<Resource>() {

            @Override
            public void onResponse(Call<Resource> call, Response<Resource> response) {
                if (response.isSuccessful()) {
                    view.setResource(response.body());
                } else {
                    OCCILoginResponse occiLoginResponse = errorUtil.parseError(response);
                    //loginView.showLoginError(occiLoginResponse.getErrors());
                }
            }

            @Override
            public void onFailure(Call<Resource> call, Throwable t) {
                // handle execution failures like no internet connectivity
            }
        };
        manageVmRepository.vmAction(callback, vmid, action);
    }

    public void deleteVm(int vmid){
        Callback<Resource> callback = new Callback<Resource>() {

            @Override
            public void onResponse(Call<Resource> call, Response<Resource> response) {
                if (response.isSuccessful()) {
                    //view.finish();
                } else {
                    OCCILoginResponse occiLoginResponse = errorUtil.parseError(response);
                    //loginView.showLoginError(occiLoginResponse.getErrors());
                }
            }

            @Override
            public void onFailure(Call<Resource> call, Throwable t) {
                // handle execution failures like no internet connectivity
            }
        };
        manageVmRepository.vmDelete(callback, vmid);
    }

    public void startVm(int vmid, ActionWithAttributes action){
        Callback<Resource> callback = new Callback<Resource>() {

            @Override
            public void onResponse(Call<Resource> call, Response<Resource> response) {
                if (response.isSuccessful()) {
                    view.setResource(response.body());
                } else {
                    OCCILoginResponse occiLoginResponse = errorUtil.parseError(response);
                    //loginView.showLoginError(occiLoginResponse.getErrors());
                }
            }

            @Override
            public void onFailure(Call<Resource> call, Throwable t) {
                // handle execution failures like no internet connectivity
            }
        };
        manageVmRepository.vmAction(callback, vmid, action);
    }

}
