package hu.bme.dszenasi.circleandroid.managevm.ui;

import android.content.Intent;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;

import javax.inject.Inject;

import hu.bme.dszenasi.circleandroid.MyApplication;
import hu.bme.dszenasi.circleandroid.R;
import hu.bme.dszenasi.circleandroid.occicore.Action;
import hu.bme.dszenasi.circleandroid.occicore.ActionAttributes;
import hu.bme.dszenasi.circleandroid.occicore.ActionWithAttributes;
import hu.bme.dszenasi.circleandroid.occicore.Resource;
import hu.bme.dszenasi.circleandroid.vmlist.ui.VmListPresenter;

/**
 * Created by mszenasi on 2016-04-28.
 */
public class ManageVmActivity extends AppCompatActivity implements ManageVmView {

    @Inject
    ManageVmPresenter manageVmPresenter;

    TextView computeArchitecture;
    TextView computeState;
    TextView computeStateMessage;
    TextView computeMemory;
    TextView computeShare;
    TextView computeCores;
    TextView computeHostname;
    TextView credentialsCommand;
    TextView credentialsHost;
    TextView credentialsPassword;
    TextView credentialsPort;
    TextView credentialsProtocol;
    TextView credentialsUsername;

    Button start;
    Button restart;
    Button suspend;
    Button delete;
    int id;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.manage_activity);
        injectDependencies();

        manageVmPresenter.setView(this);

        computeArchitecture = (TextView) findViewById(R.id.arhitecture);
        computeState = (TextView) findViewById(R.id.state);
        computeStateMessage = (TextView) findViewById(R.id.stateMessage);
        computeMemory = (TextView) findViewById(R.id.memory);
        computeShare = (TextView) findViewById(R.id.share);
        computeCores = (TextView) findViewById(R.id.cores);
        computeHostname = (TextView) findViewById(R.id.hostname);
        credentialsCommand = (TextView) findViewById(R.id.command);
        credentialsHost = (TextView) findViewById(R.id.host);
        credentialsPassword = (TextView) findViewById(R.id.credentialspassword);
        credentialsPort = (TextView) findViewById(R.id.port);
        credentialsProtocol = (TextView) findViewById(R.id.protocol);
        credentialsUsername = (TextView) findViewById(R.id.username);

        start = (Button) findViewById(R.id.start);
        restart = (Button) findViewById(R.id.restart);
        suspend = (Button) findViewById(R.id.suspend);
        delete = (Button) findViewById(R.id.delete);

        Resource value;
        Bundle bundle = getIntent().getExtras();
        if (bundle != null) {
            value = bundle.getParcelable("resource");
            setResource(value);
        }

        start.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                manageVmPresenter.startVm(id, new Action("http://schemas.ogf.org/occi/infrastructure/compute/action#start"));

            }
        });
        restart.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                manageVmPresenter.startVm(id, new ActionWithAttributes("http://schemas.ogf.org/occi/infrastructure/compute/action#restart", new ActionAttributes("cold")));

            }
        });
        suspend.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                manageVmPresenter.startVm(id, new ActionWithAttributes("http://schemas.ogf.org/occi/infrastructure/compute/action#suspend", new ActionAttributes("suspend")));

            }
        });
        delete.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                manageVmPresenter.deleteVm(id);

            }
        });

    }

    public void setResource(Resource resource){
        id = resource.getId();
        computeArchitecture.setText(resource.getAttributes().getComputeArchitecture());
        computeState.setText(resource.getAttributes().getComputeState());
        computeStateMessage.setText(resource.getAttributes().getComputeStateMessage());
        computeMemory.setText(String.valueOf(resource.getAttributes().getComputeMemory()));
        computeShare.setText(String.valueOf(resource.getAttributes().getComputeShare()));
        computeCores.setText(String.valueOf(resource.getAttributes().getComputeCores()));
        computeHostname.setText(resource.getAttributes().getComputeHostname());
        credentialsCommand.setText(resource.getAttributes().getCredentialsCommand());
        credentialsHost.setText(resource.getAttributes().getCredentialsHost());
        credentialsPassword.setText(resource.getAttributes().getCredentialsPassword());
        credentialsPort.setText(String.valueOf(resource.getAttributes().getCredentialsPort()));
        credentialsProtocol.setText(resource.getAttributes().getCredentialsProtocol());
        credentialsUsername.setText(resource.getAttributes().getCredentialsUsername());

    }

    public void finish(){
        finish();
    }
    @Override
    public void onCreate(Bundle savedInstanceState, PersistableBundle persistentState) {
        super.onCreate(savedInstanceState, persistentState);
    }

    @Override
    protected void onDestroy() {
        manageVmPresenter.destroyView();
        super.onDestroy();
    }

    protected void injectDependencies() {
        ((MyApplication) getApplication()).getManageVmComponent().inject(this);
    }
}
