package hu.bme.dszenasi.circleandroid.managevm.module;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import hu.bme.dszenasi.circleandroid.core.util.ErrorUtil;
import hu.bme.dszenasi.circleandroid.core.util.SelfSigningClientBuilder;
import hu.bme.dszenasi.circleandroid.managevm.repository.ManageVmRepository;
import hu.bme.dszenasi.circleandroid.managevm.ui.ManageVmPresenter;
import hu.bme.dszenasi.circleandroid.managevm.ui.ManageVmPresenterImpl;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by mszenasi on 2016-04-28.
 */
@Module
public class ManageVmModule {


        String mBaseUrl;

        public ManageVmModule(String baseUrl) {
            this.mBaseUrl = baseUrl;
        }

        @Provides
        @Singleton
        public ManageVmRepository providesManageVmRepository(Retrofit retrofit) {
            return new ManageVmRepository(retrofit);
        }

        @Provides
        @Singleton
        public ManageVmPresenter providesManageVmPresenter(ManageVmRepository manageVmRepository, ErrorUtil errorUtil) {
            return new ManageVmPresenterImpl(manageVmRepository, errorUtil);
        }

        @Provides
        @Singleton
        SharedPreferences providesSharedPreferences(Application application) {
            return PreferenceManager.getDefaultSharedPreferences(application);
        }

        @Provides
        @Singleton
        OkHttpClient provideOkHttpClient(Application application) {
            return SelfSigningClientBuilder.createClient(application);

        }

        @Provides
        @Singleton
        ErrorUtil provideErrorUtil(Retrofit retrofit) {
            return new ErrorUtil(retrofit);

        }

        //gson
        @Provides
        @Singleton
        Retrofit provideRetrofit(OkHttpClient okHttpClient) {
            Retrofit retrofit = new Retrofit.Builder()
                    .baseUrl(mBaseUrl)
                    .addConverterFactory(GsonConverterFactory.create())
                    .client(okHttpClient)
                    .build();
            return retrofit;
        }

    }
