package hu.bme.dszenasi.circleandroid.login.ui;

import java.io.IOException;

import hu.bme.dszenasi.circleandroid.core.util.ErrorUtil;
import hu.bme.dszenasi.circleandroid.occicore.LoginData;
import hu.bme.dszenasi.circleandroid.occicore.OCCILoginResponse;
import hu.bme.dszenasi.circleandroid.login.repository.ILoginRepository;
import okhttp3.ResponseBody;
import retrofit.JacksonConverterFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by mszenasi on 2016-04-26.
 */
public class LoginPresenterImpl implements LoginPresenter {
    ILoginRepository loginRepository;
    LoginView loginView;
    ErrorUtil errorUtil;

    public LoginPresenterImpl(ILoginRepository loginRepository, ErrorUtil errorUtil) {
        this.loginRepository = loginRepository;
        this.errorUtil = errorUtil;
    }

    @Override
    public void login(LoginData loginData) {
        Callback<OCCILoginResponse> callback = new Callback<OCCILoginResponse>() {

            @Override
            public void onResponse(Call<OCCILoginResponse> call, Response<OCCILoginResponse> response) {
                if (response.isSuccessful()) {
                    loginView.onLoginSucces();
                } else {
                    OCCILoginResponse occiLoginResponse = errorUtil.parseError(response);
                    loginView.showLoginError(occiLoginResponse.getErrors());
                }
            }

            @Override
            public void onFailure(Call<OCCILoginResponse> call, Throwable t) {
                // handle execution failures like no internet connectivity
            }
        };
        loginRepository.login(callback, loginData);
    }

    @Override
    public void attachView(LoginView loginView) {
        this.loginView = loginView;
    }

    @Override
    public void detachView() {
        loginView = null;
    }
}
