package hu.bme.dszenasi.circleandroid.login.ui;

import android.content.Intent;

import android.support.v7.app.AppCompatActivity;

import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.EditorInfo;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import java.util.List;

import javax.inject.Inject;

import hu.bme.dszenasi.circleandroid.MyApplication;
import hu.bme.dszenasi.circleandroid.R;
import hu.bme.dszenasi.circleandroid.occicore.LoginData;
import hu.bme.dszenasi.circleandroid.vmlist.ui.VmListActivity;

/**
 * A login screen that offers login via email/password.
 */
public class LoginActivity extends AppCompatActivity implements LoginView {

    @Inject
    LoginPresenter loginPresenter;
    /**
     * Id to identity READ_CONTACTS permission request.
     */
    private static final int REQUEST_READ_CONTACTS = 0;
    // UI references.
    private AutoCompleteTextView mUsernameView;
    private EditText mPasswordView;
    private TextView errorView;
    private Button mConnectButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        injectDependencies();
        loginPresenter.attachView(this);
        setContentView(R.layout.activity_login);
        mUsernameView = (AutoCompleteTextView) findViewById(R.id.username);
        mPasswordView = (EditText) findViewById(R.id.password);
        errorView = (TextView) findViewById(R.id.error);
        mPasswordView.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView textView, int id, KeyEvent keyEvent) {
                if (id == R.id.login || id == EditorInfo.IME_NULL) {
                    attemptLogin();
                    return true;
                }
                return false;
            }
        });
        mConnectButton = (Button) findViewById(R.id.email_sign_in_button);
        mConnectButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                attemptLogin();
            }
        });
    }

    @Override
    protected void onDestroy() {
        loginPresenter.detachView();
        super.onDestroy();
    }

    protected void injectDependencies() {
        ((MyApplication) getApplication()).getloginComponent().inject(this);
    }

    private void attemptLogin() {
        if (isEmailValid(mUsernameView.getText().toString())) {
            LoginData loginData = new LoginData(mUsernameView.getText().toString(), mPasswordView.getText().toString());
            loginPresenter.login(loginData);
        }
    }

    private boolean isEmailValid(String email) {
        //TODO: Replace this with your own logic
        return true;
    }

    private boolean isPasswordValid(String password) {
        //TODO: Replace this with your own logic
        return password.length() > 4;
    }

    @Override
    public void onLoginSucces() {
        Intent intent = new Intent(this, VmListActivity.class);
        startActivity(intent);
    }

    @Override
    public void showLoginError(List<String> errors){
        StringBuilder sb = new StringBuilder();

        for (String error : errors) {
            sb.append(error);
            sb.append(System.getProperty("line.separator"));
        }
        errorView.setText(sb);

        errorView.setVisibility(View.VISIBLE);
    }
}

