package hu.bme.dszenasi.circleandroid.login.repository;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import hu.bme.dszenasi.circleandroid.core.api.OCCICircleApi;
import hu.bme.dszenasi.circleandroid.occicore.LoginData;
import hu.bme.dszenasi.circleandroid.occicore.OCCILoginResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;


/**
 * Created by mszenasi on 2016-04-26.
 */
public class LoginRepository implements ILoginRepository {
    private Retrofit retrofit;

    public LoginRepository(Retrofit retrofit) {
        this.retrofit = retrofit;
    }

    public void login(final Callback<OCCILoginResponse> callback, final LoginData loginData) {
        OCCICircleApi occiCircleApi = retrofit.create(OCCICircleApi.class);
        Callback<OCCILoginResponse> callback1 = new Callback<OCCILoginResponse>() {

            @Override
            public void onResponse(Call<OCCILoginResponse> call, Response<OCCILoginResponse> response) {
                postLogin(callback, loginData);
            }

            @Override
            public void onFailure(Call<OCCILoginResponse> call, Throwable t) {
                System.out.print("asas");
            }
        };
        occiCircleApi.loginGet().enqueue(callback1);
    }

    private void postLogin(Callback<OCCILoginResponse> callback, LoginData loginData) {
        OCCICircleApi occiCircleApi = retrofit.create(OCCICircleApi.class);
        occiCircleApi.loginPost(loginData).enqueue(callback);
    }

}
